<div class="card overflow-hidden">
    <div class="card-body">
        <div class="d-flex">
            <div class="mt-2">
                <h6 class=""><?php echo e($title); ?></h6>
                <h2 class="mb-0 number-font"><?php echo e(number_format($currentValue)); ?></h2>
            </div>
            <div class="ms-auto">
                <div class="chart-wrapper mt-1">
                    <canvas id="<?php echo e($type); ?>" class="h-8 w-9 chart-dropshadow"></canvas>
                </div>
            </div>
        </div>
        <span class="text-muted fs-12">
            <span style="color: <?php echo e($color); ?>">
                <i class="fe fe-arrow-up-circle"></i> <?php echo e($percentageChange); ?>%
            </span>
            Last week
        </span>
    </div>
</div>

<?php $__env->startPush('script'); ?>
<?php if (! $__env->hasRenderedOnce('5bf0b1a8-8970-4ab1-831c-04685f0175e3')): $__env->markAsRenderedOnce('5bf0b1a8-8970-4ab1-831c-04685f0175e3'); ?>
<!-- INTERNAL CHARTJS CHART JS-->
<script src="<?php echo e(asset('backend/plugins/chart/Chart.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/chart/rounded-barchart.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/chart/utils.js')); ?>"></script>
<?php endif; ?>
<script>
    var ctx = document.getElementById('<?php echo e($type); ?>').getContext('2d');
    ctx.height = 10;
    var myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            datasets: [{
                label: '<?php echo e($title); ?>',
                barGap: 0,
                barSizeRatio: 1,
                data: <?php echo json_encode($chartData, 15, 512) ?>,
                backgroundColor: '<?php echo e($color); ?>',
                borderColor: '<?php echo e($color); ?>',
                pointBackgroundColor: '#fff',
                pointHoverBackgroundColor: '<?php echo e($color); ?>',
                pointBorderColor: '<?php echo e($color); ?>',
                pointHoverBorderColor: '<?php echo e($color); ?>',
                pointBorderWidth: 2,
                pointRadius: 2,
                pointHoverRadius: 2,
                borderWidth: 1
            }, ]
        },
        options: {
            maintainAspectRatio: false,
            legend: {
                display: false
            },
            responsive: true,
            tooltips: {
                enabled: false,
            },
            scales: {
                xAxes: [{
                    categoryPercentage: 1.0,
                    barPercentage: 1.0,
                    barDatasetSpacing: 0,
                    display: false,
                    barThickness: 5,
                    gridLines: {
                        color: 'transparent',
                        zeroLineColor: 'transparent'
                    },
                    ticks: {
                        fontSize: 2,
                        fontColor: 'transparent'
                    }
                }],
                yAxes: [{
                    display: false,
                    ticks: {
                        display: false,
                    }
                }]
            },
            title: {
                display: false,
            },
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/components/widget.blade.php ENDPATH**/ ?>